/*
 * Decompiled with CFR 0.152.
 */
package com.mcsync.plugin;

import java.util.UUID;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.ScopedNode;
import net.luckperms.api.node.types.InheritanceNode;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;

public class PermissionAssigner {
    private final LuckPerms luckPerms;
    private final FileConfiguration config;

    public PermissionAssigner(LuckPerms luckPerms, FileConfiguration config) {
        this.luckPerms = luckPerms;
        this.config = config;
    }

    public void assignPermissions(String player, UUID uuid, String parameters, int tier) {
        if (this.luckPerms == null) {
            if (parameters.contains("debug")) {
                Bukkit.getLogger().warning("LuckPerms is not initialized!");
            }
            return;
        }
        this.luckPerms.getUserManager().modifyUser(uuid, user -> {
            if (user == null) {
                Bukkit.getLogger().warning("Failed to load user data for UUID: " + uuid);
                return;
            }
            String permissionsMode = this.config.getString("permissionsMode");
            String permissionNode = null;
            switch (tier) {
                case 1: {
                    permissionNode = this.config.getString("sub-t1");
                    break;
                }
                case 2: {
                    permissionNode = this.config.getString("sub-t2");
                    break;
                }
                case 3: {
                    permissionNode = this.config.getString("sub-t3");
                    break;
                }
                default: {
                    permissionNode = this.config.getString("override");
                }
            }
            if (permissionNode != null) {
                ScopedNode node = "group".equalsIgnoreCase(permissionsMode) ? InheritanceNode.builder((String)permissionNode).build() : Node.builder((String)permissionNode).build();
                user.data().add((Node)node);
                if (parameters.contains("debug")) {
                    Bukkit.getLogger().info("Assigned permission '" + permissionNode + "' to " + player + " (Tier: " + tier + ")");
                }
            } else if (parameters.contains("debug")) {
                Bukkit.getLogger().warning("No permission node found for tier " + tier + " or override.");
            }
        });
    }
}

